IF NOT EXISTS (SELECT * FROM SYS.TABLES WHERE NAME = 'EST_PROD_TRILHO_EXCESSO_ITENS') 
BEGIN
	CREATE TABLE [dbo].[EST_PROD_TRILHO_EXCESSO_ITENS](
		[CD_EMP] [int] NOT NULL,
		[CD_FILIAL] [int] NOT NULL,
		[CD_CTR] [int] NOT NULL,
		[CD_PROD] [int] NOT NULL,
		[QTDE_EXCESSO] [money] NOT NULL,
		[QTDE_ENVIADA] [money] NOT NULL,
	 CONSTRAINT [PK_EST_PROD_TRILHO_EXCESSO_ITENS] PRIMARY KEY CLUSTERED 
	(
		[CD_EMP] ASC,
		[CD_FILIAL] ASC,
		[CD_CTR] ASC,
		[CD_PROD] ASC
	)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 80) ON [PRIMARY]
	) ON [PRIMARY]


	ALTER TABLE [dbo].[EST_PROD_TRILHO_EXCESSO_ITENS]  WITH CHECK ADD  CONSTRAINT [FK_EST_PROD_TRILHO_EXCESSO_ITENS_EST_PROD_TRILHO_EXCESSO] FOREIGN KEY([CD_EMP], [CD_FILIAL], [CD_CTR])
	REFERENCES [dbo].[EST_PROD_TRILHO_EXCESSO] ([CD_EMP], [CD_FILIAL], [CD_CTR])

	ALTER TABLE [dbo].[EST_PROD_TRILHO_EXCESSO_ITENS] CHECK CONSTRAINT [FK_EST_PROD_TRILHO_EXCESSO_ITENS_EST_PROD_TRILHO_EXCESSO]

	ALTER TABLE [dbo].[EST_PROD_TRILHO_EXCESSO_ITENS] ADD  CONSTRAINT [DF_EST_PROD_TRILHO_EXCESSO_ITENS_CD_EMP]  DEFAULT ((0)) FOR [CD_EMP]

	ALTER TABLE [dbo].[EST_PROD_TRILHO_EXCESSO_ITENS] ADD  CONSTRAINT [DF_EST_PROD_TRILHO_EXCESSO_ITENS_CD_FILIAL]  DEFAULT ((0)) FOR [CD_FILIAL]

	ALTER TABLE [dbo].[EST_PROD_TRILHO_EXCESSO_ITENS] ADD  CONSTRAINT [DF_EST_PROD_TRILHO_EXCESSO_ITENS_CD_CTR]  DEFAULT ((0)) FOR [CD_CTR]

	ALTER TABLE [dbo].[EST_PROD_TRILHO_EXCESSO_ITENS] ADD  CONSTRAINT [DF_EST_PROD_TRILHO_EXCESSO_ITENS_CD_PROD]  DEFAULT ((0)) FOR [CD_PROD]

	ALTER TABLE [dbo].[EST_PROD_TRILHO_EXCESSO_ITENS] ADD  CONSTRAINT [DF_EST_PROD_TRILHO_EXCESSO_ITENS_QTDE_EXCESSO]  DEFAULT ((0)) FOR [QTDE_EXCESSO]

	ALTER TABLE [dbo].[EST_PROD_TRILHO_EXCESSO_ITENS] ADD  CONSTRAINT [DF_EST_PROD_TRILHO_EXCESSO_ITENS_QTDE_ENVIADA]  DEFAULT ((0)) FOR [QTDE_ENVIADA]

END